"""
Implementation of a TreeEditor demo plugin for the Traits UI demo program.
"""

from enthought.traits.api import HasTraits, Str, Regex, List, Instance
from enthought.traits.ui.api import Item, Group, View, TreeEditor, TreeNode

class Employee ( HasTraits ):
     name = Str( '<unknown>' )
     title = Str
     phone = Regex( regex = r'\d\d\d-\d\d\d\d' )
    
     def default_title ( self ):
          self.title = 'Senior Engineer'


class Department ( HasTraits ):
     name = Str( '<unknown>' )
     employees = List( Employee )


class Company ( HasTraits ):
     name = Str( '<unknown>' )
     departments = List( Department )
     employees   = List( Employee )
        

class Partner ( HasTraits ):
     name = Str( '<unknown>' )
     company = Instance( Company )


no_view = View()


tree_editor = TreeEditor( 
    nodes = [
        TreeNode( node_for  = [ Company ],
                  auto_open = True,
                  children = '',
                  label = 'name',
                  view = View( [ 'name' ] ) ),
        TreeNode( node_for  = [ Company ],
                  auto_open = True,
                  children = 'departments',
                  label = '=Departments',
                  view = no_view,
                  add = [ Department ] ),
        TreeNode( node_for  = [ Company ],
                  auto_open = True,
                  children = 'employees',
                  label = '=Employees',
                  view = no_view,
                  add = [ Employee ] ),
        TreeNode( node_for  = [ Department ],
                  auto_open = True,
                  children = 'employees',
                  label = 'name',
                  view = View( [ 'name' ] ),
                  add = [ Employee ] ),
        TreeNode( node_for  = [ Employee ],
                  auto_open = True,
                  label = 'name',
                  view = View( [ 'name', 'title', 'phone' ] ) ) ] )



view = View( Group( Item( name = 'company',   
                          editor = tree_editor, 
                          resizable = True ),
                    show_labels=False ),
             title = 'Company Structure',
             buttons = [ 'OK' ],
             resizable = True,
             width = .3,
             height = .3 )



jas = Employee(name='Jason', title='Senior Engineer', phone='536-1057')
mike= Employee(name='Mike', title='Senior Engineer', phone='536-1057')
bus = Department(name='Business', employees=[jas, mike])
dave = Employee(name='Dave', title='Senior Software Developer', phone='536-1057')
martin = Employee(name='Martin', title='Senior Engineer', phone='536-1057')
duncan = Employee(name='Duncan', title='Consultant', phone='526-1057')
sci = Department(name='Scientific', employees=[dave, martin, duncan])
enthought = Company(name='Enthought', departments=[bus, sci], employees=[dave, martin, duncan, jas, mike])


popup = Partner(name = 'Enthought, Inc.', company=enthought)

if __name__ == "__main__":
    popup.configure_traits(view=view)
